/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.ai.GdxAI;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.GameUpdateRegister;
import technology.rocketjump.undermount.input.GameWorldInputHandler;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.GameRenderer;
import technology.rocketjump.undermount.rendering.camera.DisplaySettings;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.ui.GuiContainer;

@Singleton
public class MainGameScreen
implements GameContextAware,
Screen {
    private final GameRenderer gameRenderer;
    private final PrimaryCameraWrapper primaryCameraWrapper;
    private final GuiContainer guiContainer;
    private final DebugWindow debugWindow;
    private final GameWorldInputHandler gameWorldInputHandler;
    private GameContext gameContext;
    private GameUpdateRegister gameUpdateRegister;

    @Inject
    public MainGameScreen(GameRenderer gameRenderer, PrimaryCameraWrapper primaryCameraWrapper, GuiContainer guiContainer, DebugWindow debugWindow, GameWorldInputHandler gameWorldInputHandler, GameUpdateRegister gameUpdateRegister) {
        this.gameRenderer = gameRenderer;
        this.primaryCameraWrapper = primaryCameraWrapper;
        this.guiContainer = guiContainer;
        this.debugWindow = debugWindow;
        this.gameWorldInputHandler = gameWorldInputHandler;
        this.gameUpdateRegister = gameUpdateRegister;
    }

    @Override
    public void render(float deltaTime) {
        this.updateGameLogic(deltaTime);
        this.gameRenderer.renderGame(this.gameContext.getAreaMap(), this.primaryCameraWrapper.getCamera());
        if (DisplaySettings.showGui) {
            this.guiContainer.render();
        }
    }

    private void updateGameLogic(float deltaTime) {
        this.debugWindow.clearText();
        float multipliedDeltaTime = deltaTime * this.gameContext.getGameClock().getSpeedMultiplier();
        if (!this.gameContext.getGameClock().isPaused()) {
            GdxAI.getTimepiece().update(multipliedDeltaTime);
            this.gameContext.getGameClock().update(multipliedDeltaTime);
        }
        this.primaryCameraWrapper.update(deltaTime);
        this.gameUpdateRegister.update(multipliedDeltaTime, this.gameContext.getGameClock().isPaused());
        this.guiContainer.update(deltaTime);
    }

    @Override
    public void show() {
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(this.guiContainer.getInputProcessor());
        inputMultiplexer.addProcessor(this.gameWorldInputHandler);
        Gdx.input.setInputProcessor(inputMultiplexer);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

